/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rescrcon;

import com.ibm.hwmca.base.rescrcon.ConfirmTheActionBean;
import com.ibm.hwmca.base.rescrcon.RestoreCriticalConsoleDataResourceBundle;
import com.ibm.hwmca.base.rescrcon.RestoreErrorIds;
import com.ibm.hwmca.base.rescrcon.RestoreException;
import com.ibm.hwmca.base.rescrcon.RestoreImpl;
import com.ibm.hwmca.base.rescrcon.RestoreParameterKeys;
import com.ibm.hwmca.base.rescrcon.RestoreParameters;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.system.StartupHook;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;

public class RestoreTasklet
extends StartupHook
implements RestoreErrorIds,
RestoreParameterKeys {
    private static final String TRACE_MASKT = "XRCCTKLT";
    private static final String TRACE_MASKF = "XRCCTKLF";
    private static final String TRACE_MASKD = "XRCCTKLD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.rescrcon.res.RestoreCriticalConsoleDataRes";
    private static final String PANEL_NAME = "ConfirmTheActionPanel";
    private boolean progressDismissed = false;
    private boolean restore_error = false;
    private UserContext usercontext = null;
    private LocalizableText taskname;
    RestoreImpl restoreImpl = null;
    RestoreParameters restoreParameters = null;
    ConfirmTheActionBean restoreBean = null;
    boolean waiting;

    public RestoreTasklet(PanelTasklet theTasklet) {
        super(theTasklet);
        Trace.trace(TRACE_MASKT, "-> RestoreTasklet.RestoreTasklet()");
        this.restoreParameters = RestoreParameters.getRestoreParameters();
        this.restoreImpl = new RestoreImpl();
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.RestoreTasklet()");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> RestoreTasklet.service()");
        try {
            if (taskletRequest.isInitialRequest()) {
                Trace.trace(TRACE_MASKF, "initial request");
            }
            if (!this.restoreImpl.isRestoreNeeded()) {
                this.finished(1);
            } else {
                boolean done = false;
                while (!done) {
                    try {
                        this.restoreImpl.restorePreparation();
                        done = true;
                        Trace.trace(TRACE_MASKF, "completed restore preparation");
                        this.popProgressWindow();
                        Trace.trace(TRACE_MASKF, "done with restore, now reboot...");
                        if (this.restore_error) {
                            this.finished(1);
                            continue;
                        }
                        this.finished(3);
                    }
                    catch (RestoreException rexc) {
                        Trace.trace(TRACE_MASKF, "caught exception: " + rexc.getMessage());
                        Object[] restoreErrorMsg = new String[1];
                        MessageText[] bmt = new BaseMessageText[1];
                        if (this.restoreImpl.getState() > 8) {
                            restoreErrorMsg[0] = rexc.getMessage();
                            bmt[0] = new BaseMessageText("RES00006", restoreErrorMsg);
                        } else {
                            restoreErrorMsg[0] = new LocalizableText("com/ibm/hwmca/base/rescrcon/res/restoreres", RestoreCriticalConsoleDataResourceBundle.RestoreErrors(this.restoreImpl.getState())).toString();
                            bmt[0] = new BaseMessageText("RES00005", restoreErrorMsg);
                        }
                        BaseMessageText title = new BaseMessageText("RES00008");
                        LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON};
                        LocalizableText userResponse = this.tasklet.showMessageBox(true, title, bmt, "ACT0201E", MsgType.ERROR_MESSAGE, options);
                        if (!userResponse.equals(CommonMsgInterface.CANCEL_BUTTON)) continue;
                        done = true;
                        this.finished(3);
                    }
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception during init: " + e);
            HException hexc = new HException(e);
            new FrameworkLog(RestoreErrorIds._logInfo, 514, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.service()");
    }

    private void notifyThisTasklet() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void popProgressWindow() {
        block8: {
            Trace.trace(TRACE_MASKT, "-> RestoreTasklet.run()");
            long duration = new Long(this.restoreParameters.getParm("restore.duration"));
            LocalizableText initialText = new LocalizableText("In progress...");
            String id = "1";
            this.taskname = new LocalizableText("Restore Console Data");
            ObjectId[] thisId = new ObjectId[1];
            Trace.trace(TRACE_MASKF, "cast the panel tasklet");
            PanelTasklet panelTasklet = this.tasklet;
            Trace.trace(TRACE_MASKF, "now create an object id for the panel tasklet");
            thisId[0] = new ObjectId(panelTasklet);
            ProgressData[] progData = new ProgressData[1];
            Trace.trace(TRACE_MASKF, "create a progress data array");
            progData[0] = new ProgressData(this.taskname, thisId[0], duration);
            Trace.trace(TRACE_MASKF, "create a progress listener");
            PanelTaskletProgressListener progListener = new PanelTaskletProgressListener(panelTasklet);
            try {
                try {
                    Trace.trace(TRACE_MASKF, "create a progress start event");
                    ProgressStartEvent start = new ProgressStartEvent(this.taskname, progData, duration, initialText, id);
                    Trace.trace(TRACE_MASKF, "start the listener");
                    progListener.startProgress(start);
                    Trace.trace(TRACE_MASKF, "create a restore progress listener");
                    ProgressReportListenerImpl restoreListener = new ProgressReportListenerImpl(id, thisId, progListener);
                    Trace.trace(TRACE_MASKF, "waiting for the progress window to be dismissed");
                    RestoreTasklet restoreTasklet = this;
                    synchronized (restoreTasklet) {
                        this.restoreImpl.restore(restoreListener);
                    }
                    Trace.trace(TRACE_MASKF, "progress window has been dismissed, so now we can end");
                }
                catch (RestoreException rexc) {
                    Trace.trace(TRACE_MASKF, "restore exception caught: " + rexc.getMessage());
                    this.restore_error = true;
                    Object var14_16 = null;
                    break block8;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "exception caught in run: " + e.getMessage());
                    progListener.endProgress(new ProgressEndEvent(id));
                    RestoreException rexc = new RestoreException(e);
                    new FrameworkLog(RestoreErrorIds._logInfo, 514, rexc).log();
                    Object var14_17 = null;
                }
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.run()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> RestoreTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        HException hexc = new HException(throwable);
        new FrameworkLog(RestoreErrorIds._logInfo, 512, hexc).log();
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> RestoreTasklet.progressEnded()");
        RestoreTasklet restoreTasklet = this;
        synchronized (restoreTasklet) {
            this.progressDismissed = true;
            this.notify();
        }
        Trace.trace(TRACE_MASKT, "<- RestoreTasklet.progressEnded()");
    }
}

